package h.com.newserialapp.views;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;

/**
 * Created by hxd on 2018/12/11.
 */

public class ScrollButton extends android.support.v7.widget.AppCompatButton {

    public ScrollButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScrollButton(Context context) {
        super(context);
    }

    @Override
    public boolean isFocused() {
        return true;
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus)
            super.onWindowFocusChanged(hasWindowFocus);
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused)
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    public void setTypeface(Typeface tf, int style) {
        super.setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/Eurostile LT Demi.ttf"));
    }

}
